#! /bin/bash

set -o errexit
trap "rm -rf c-code *.c *.h readme.txt *.new *.def *.all" ERR

if [ "$0" = prepare_sources.sh ] ; then
    cd "$(if ! which 2>/dev/null prepare_sources.sh ; then echo . fi )"
else
    cd "${0%/*}"
fi

rm -rf c-code *.c *.h readme.txt
unzip 26104-610_ANSI_C_source_code.zip

for FILE in readme.txt c-code/*.c  c-code/*.h ; do
    tr -d '\r' <$FILE >${FILE#*/}.new
    mv ${FILE#*/}.new ${FILE#*/}
done

rm -r c-code

patch <amrnb-intsizes.patch
patch <amrnb-strict-aliasing.patch
patch <amrnb-any-cflags.patch

for FILE in interf_{dec,enc}.{c,h} ; do
    echo "modifying file $FILE"
    if test $FILE = ${FILE%.h} ; then
	ENDSTRING="^}"
    else
	ENDSTRING=");"
    fi
    sed -n "/^[^# ][^ ]* \(VADx\|\)..coder_Interface_..code/,/$ENDSTRING/p" <$FILE >$FILE.def
    sed 's/^\([^# ][^ ]*\) \(VADx\|\)\(..coder_Interface_..code\)/\1 GP3\2\3/
	 s:ifndef IF2:if 1 /* & */:
	 s:ifdef IF2:if 0 /* & */:
	 s:ifndef ETSI:if 1 /* & */:
	 s:ifdef ETSI:if 0 /* & */:
	' <$FILE.def >$FILE.all
    sed 's/^\([^# ][^ ]*\) \(VADx\|\)\(..coder_Interface_..code\)/\1 IF2\2\3/
	 s:ifndef IF2:if 0 /* & */:
	 s:ifdef IF2:if 1 /* & */:
	 s:ifndef ETSI:if 1 /* & */:
	 s:ifdef ETSI:if 0 /* & */:
	' <$FILE.def >>$FILE.all
    sed 's/^\([^# ][^ ]*\) \(VADx\|\)\(..coder_Interface_..code\)/\1 ETSI\2\3/
	 s:ifndef IF2:if 1 /* & */:
	 s:ifdef IF2:if 0 /* & */:
	 s:ifndef ETSI:if 0 /* & */:
	 s:ifdef ETSI:if 1 /* & */:
	' <$FILE.def >>$FILE.all
    sed "/^[^# ][^ ]* \(VADx\|\)..coder_Interface_..code/,/$ENDSTRING/c\\
/* Triple the code with different defines and names */" <$FILE |
    sed "/Triple the code with different defines and names/r $FILE.all" >$FILE.new
    mv $FILE.new $FILE
    rm $FILE.def $FILE.all
done
for FILE in sp_enc.c ; do
    echo "modifying file $FILE"
    if test $FILE = ${FILE%.h} ; then
	ENDSTRING="^}"
    else
	ENDSTRING=");"
    fi
    for FUNCTION in Lag_max Pitch_ol Lag_max_wght Pitch_ol_wgh cod_amr cod_amr_reset ol_ltp ; do
	rm -f $FILE.all
	sed -n "/^static [^ ]* $FUNCTION(/,/$ENDSTRING/p" <$FILE >$FILE.def
	sed "s/^\(static [^ ]*\) \($FUNCTION\)(/\1 VAD1\2(/
	     s:ifndef VAD2:if 1 /* & */:
	     s:ifdef VAD2:if 0 /* & */:
	     s:vadState:vad1State:g
	     s:\([= ] \)\(Lag_max\|ol_ltp\|Pitch_ol\):\1VAD1\2:g
	     s:\([a-z][a-z]*\)->vadSt:((vad1State*)(\1->vadSt)):g
	    " <$FILE.def >$FILE.all
	sed "s/^\(static [^ ]*\) \($FUNCTION\)(/\1 VAD2\2(/
	     s:ifndef VAD2:if 0 /* & */:
	     s:ifdef VAD2:if 1 /* & */:
	     s:vadState:vad2State:g
	     s:\([= ] \)\(Lag_max\|ol_ltp\|Pitch_ol\):\1VAD2\2:g
	     s:\([a-z][a-z]*\)->vadSt:((vad2State*)(\1->vadSt)):g
	    " <$FILE.def >>$FILE.all
	sed "/^static [^ ]* \($FUNCTION\)(/,/$ENDSTRING/c\\
/* Double the $FUNCTION code with different defines and names */" <$FILE |
	sed "/Double the $FUNCTION code with different defines and names/r $FILE.all" >$FILE.new
	mv $FILE.new $FILE
	rm $FILE.def $FILE.all
    done
done
